import time
import random

def slow_print(text):
    print(text)
    time.sleep(1.5)

def start_game():
    slow_print("🔒 You wake up locked inside the Space Shuttle!")
    slow_print("You have to escape before the doors are locked for take off to the Moon.")
   
    global key_location
    key_location = random.choice(["utility wall", "fuselage", "compartment"])
    explored_room()

def explored_room():
    has_key = False
    checked_spots = set()

    while not has_key:
        slow_print("\nWhere do you want to look?")
        slow_print("1. Utility Wall")
        slow_print("2. Fuselage")
        slow_print("3. Compartment")

        choice1 = input("What will you check? (1, 2, or 3): ")

        if choice1 == "1" and "utility wall" not in checked_spots:
            has_key = utility()
            checked_spots.add("utility wall")
        elif choice1 == "2" and "fuselage" not in checked_spots:
            has_key = fuselage()
            checked_spots.add("fuselage")
        elif choice1 == "3" and "compartment" not in checked_spots:
            has_key = compartment()
            checked_spots.add("compartment")
        elif choice1 in ["1", "2", "3"]:
            slow_print("You've already checked that. Try somewhere else!")
        else:
            slow_print("That's not a valid choice.")

    next_room(has_key)

def utility():
    slow_print("\n📦 You pull back the utility wall and see a small locked box.")
    slow_print("It has a 3-digit code lock. A sticky note on top says:")
    slow_print('"What number do you get if you multiply all the numbers on a phone keypad?" 🤔')

    code = input("Enter the 3-digit code to unlock the box: ")

    if code == "000":
        if key_location == "utility wall":
            slow_print("\n✅ Correct! The box pops open.")
            slow_print("Inside is a small key taped under the lid. You got it! 🔑")
            return True
        else:
            slow_print("\n✅ Correct, but the box is empty... Just a joke inside. 😆")
            return False
    else:
        slow_print("\n❌ Wrong code. The box stays locked.")
        return False

def fuselage():
    slow_print("\n🚪 You try to open the fuselage. It has a word puzzle:")
    slow_print('"I have hands but no arms, and a face but no eyes. What am I?"')

    answer = input("Enter your answer: ").strip().lower()

    if answer == "clock":
        if key_location == "fuselage":
            slow_print("\n✅ Correct! The fuselage unlocks.")
            slow_print("You find a key taped behind the door! 🔑")
            return True
        else:
            slow_print("\n✅ Correct — but there's only a cap. No key. ⚙️")
            return False
    else:
        slow_print("\n❌ Wrong answer. The fuselage stays locked.")
        return False

def compartment():
    slow_print("\n🌈 You open the compartment and find a colourful card with a riddle:")
    slow_print('"red + blue = ?"')

    answer = input("What colour do you get? ").strip().lower()

    if answer == "purple":
        if key_location == "compartment":
            slow_print("\n✅ Correct! Hidden under the card is a key! 🔑")
            return True
        else:
            slow_print("\n✅ Correct, but nothing else inside... except some glitter. ✨")
            return False
    else:
        slow_print("\n❌ That’s not it. Suddenly — 💥 a glitter bomb goes off!")
        return False

def next_room(has_key):
    slow_print("\nYou spot a door in the back of the space shuttle. It might be your way out.")
    action = input("Do you want to try opening the door? (yes or no): ")

    if action.lower() == "yes":
        if has_key:
            slow_print("\n🔑 You use the key you found.")
            slow_print("The door clicks open! You're free! 🎉")
            slow_print("🚀 YOU ESCAPED THE SPACE SHUTTLE! 🛰")
        else:
            slow_print("\n😬 The door is locked. You need a key.")
            slow_print("You couldn’t escape in time. GAME OVER.")
    elif action.lower() == "no":
        slow_print("\nYou decide to stay... and visit the moon? 🌝")
        slow_print("Well, that’s one way to end the game.")
    else:
        slow_print("That’s not a valid answer.")
        next_room(has_key)

start_game()